Rem
Rem $Header: ccf_georaster.sql 05-aug-2004.09:30:23 wexu Exp $
Rem
Rem ccf_georaster.sql
Rem
Rem Copyright (c) 2002, 2004, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ccf_georaster.sql
Rem
Rem    DESCRIPTION
Rem      1. Copy GeoRaster objects and/or
Rem      2. Change Format of GeoRaster objects
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    wexu        08/05/04 - RDT must be unique 
Rem    qxie        09/24/03 - optionally add rasterid in init() call 
Rem    qxie        10/31/02 - qxie_demo1
Rem    qxie        10/30/02 - Created
Rem


-------------------------------------------------------------------
-- Copy GeoRaster Objects
-------------------------------------------------------------------

declare
  gr1 mdsys.sdo_georaster;
  gr2 mdsys.sdo_georaster;
  cnt integer := 0;
begin
  --
  -- copy a blank georaster object
  --

  -- 1. initialize an empty georaster to hold the copy
  delete from georaster_table where georid = 5;
  insert into georaster_table 
    values (5, 'Blank Copy', sdo_geor.init('ST_RDT_1', 5))
    returning georaster into gr2;

  -- 2. the source blank georaster object
  select georaster into gr1
    from georaster_table where georid = 3;

  -- 3. make copy
  sdo_geor.copy(gr1, gr2);

  -- 4. store it into the georaster table
  update georaster_table set georaster = gr2 where georid = 5;


  --
  -- copy a truecolor georaster object
  --

  -- 1. initialize an empty georaster to hold the copy if not exist
  select count(*) into cnt from georaster_table where georid = 6;
  if (cnt = 0) then
   insert into georaster_table 
     values (6, 'Truecolor Reformat', sdo_geor.init('ST_RDT_2', 6));
  end if;
  select georaster into gr2 
    from georaster_table where georid = 6 for update;
 
  -- 2. the source 3-band truecolor georaster object
  select georaster into gr1 from georaster_table where georid = 4;

  -- 3. make copy
  sdo_geor.copy(gr1, gr2);

  -- 4. store it into the georaster table
  update georaster_table set georaster = gr2 where georid = 6;

  commit;
end;
/

-- quick check on the results
-- georid 5 is identical to georid 3
-- georid 6 is identical to georid 5
@validate_georaster.sql
@query_georaster.sql



-------------------------------------------------------------------
-- change the format of a GeoRaster Object
-------------------------------------------------------------------

declare
  gr1 mdsys.sdo_georaster;
  gr2 mdsys.sdo_georaster;
  cnt integer := 0;
begin
  --
  -- changeFormat of a georaster object
  --

  -- 1. the source georaster object
  select georaster into gr1 
    from georaster_table where georid = 6;

  -- 2. make changes
  sdo_geor.changeFormat(gr1, 'blocksize=(128,128,3) interleaving=BIP');

  -- 3. update it in the georaster table
  update georaster_table set georaster = gr1 where georid = 6;

  commit;

  --
  -- changeFormatCopy a georaster object
  --

  -- 1. initialize an empty georaster to hold the copy if not exist
  select count(*) into cnt from georaster_table where georid = 7;
  if (cnt = 0) then
   insert into georaster_table 
     values (7, 'TRUECOLOR', sdo_geor.init('ST_RDT_3', 7));
  end if;
  select georaster into gr2 
    from georaster_table where georid = 7 for update;

  -- 2. the source georaster object
  select georaster into gr1 from georaster_table where georid = 4;

  -- 3. make format changes and copy 
  sdo_geor.changeFormatCopy(gr1, 'blocksize=(128,128,3) interleaving=BIP', gr2);

  -- 4. update it in the georaster table
  update georaster_table set georaster = gr2 where georid = 7;

  commit;
end;
/

-- quick check on the results
-- georid 6 should be identical to georid 7
@query_georaster.sql

commit;



